<%
'
' Example code to scan Active Directory for user group membership
' using VBScript under Windows Script Host and ADSI.
'
' Usage: cscript ADGroupsExample.vbs
'
' Shawn Poulson, 2009.05.18
' explodingcoder.com
'
 
' Get current logged in user info
'Set oADSysInfo = CreateObject("ADSystemInfo")
'userDN = GetDNByID(Session("strUserName"))    ' Get DN of user
'Response.write "<br>User DN: " & userDN
 
' Quick check if user is a member of a group
'Response.write "<br>User is a member of 'CATGROUP.ALL': " & IsMemberOf(userDN, GetDNByID("CATGROUP.ALL"))
'Response.write "<br>User is a member of 'Foobar': " & IsMemberOf(userDN, GetDNByID("Foobar"))
 
' Enumerate all member group names
'tkUser = GetTokenGroups(userDN)  ' Get tokens of member groups
'Response.write "<br>User is a member of " & (UBound(tkUser) + 1) & " groups:"
'For Each tk in tkUser
'   Response.write " <br>  " & GetIDBySid(tk)
'Next
 
' Scan token list for groups
'Response.write "<br>User is a member of 'IT': " & TokenListFindSid(tkUser, GetSidByID("IT"))
'Response.write "<br>User is a member of 'Foobar': " & TokenListFindSid(tkUser, GetSidByID("Foobar"))
 
' Done
 
 
' =====================================
' Token query routines
' =====================================
 
' Is DN a member of security group?
' Usage: <bool> = IsMemberOf(<DN of object>, <DN of group>)
Function IsMemberOf(dnObject, dnGroup)
   IsMemberOf = TokenListFindSid(GetTokenGroups(dnObject), GetSidByDN(dnGroup))
End Function
 
' Gets tokenGroups attribute from the provided DN
' Usage: <Array of tokens> = GetTokenGroups(<DN of object>)
Function GetTokenGroups(dnObject)
   Dim adsObject
 
   ' Setup query of tokenGroup SIDs from dnObject
   Set adsObject = GetObject(LdapUri(dnObject))
   adsObject.GetInfoEx Array("tokenGroups"), 0
   GetTokenGroups = adsObject.GetEx("tokenGroups")
End Function
 
' Checks if the SID of a DN is found in an array of tokens.
' Usage: <bool> = TokenListFindSid(<Array of tokens>, <Object SID Byte()>)
Function TokenListFindSid(arrTokens, objectSid)
   Dim nSidSize, vSidHex, e
   TokenListFindSid = False
 
   If TypeName(objectSid) = "Byte()" Then
      ' Scan token array for object SID
      nSidSize = UBound(objectSid)
      vSidHex = ByteArrToHexString(objectSid)
      For Each e in arrTokens
         If UBound(e) = nSidSize Then
            If ByteArrToHexString(e) = vSidHex Then
               TokenListFindSid = True
               Exit For
            End If
         End If
      Next
   End If
End Function
 
' Encode Byte() to hex string
Function ByteArrToHexString(bytes)
   Dim i
   ByteArrToHexString = ""
   For i = 1 to Lenb(bytes)
      ByteArrToHexString = ByteArrToHexString & Right("0" & Hex(Ascb(Midb(bytes, i, 1))), 2)
   Next
End Function
 
' Format a DN into a valid LDAP URI
Function LdapUri(DN)
   LdapUri = "LDAP://" & Replace(DN, "/", "\/")
End Function
 
 
 
' =====================================
' Query helper routines
' =====================================
 
' Get object's SID by DN
' Usage: <SID Byte()> = GetSidByDN(<DN>)
Function GetSidByDN(objectDN)
   On Error Resume Next
   GetSidByDN = GetObject(LdapUri(objectDN)).Get("objectSid")
   On Error GoTo 0
End Function
 
' Get object's SID by ID
' Usage: <SID Byte()> = GetSidByID(<Object ID>)
Function GetSidByID(ID)
   Dim rs
   Set rs = QueryLDAP(GetRootDN, "(sAMAccountName=" & isValidString(ID) & ")", "objectSid", "subtree")
   If Not rs.EOF Then GetSidByID = stripHTML(rs("objectSid"))
   rs.Close
   Set rs = Nothing
End Function
 
' Get DN by sAMAccountName
' Usage: <DN> = GetDNByID(<User or Group ID>)
Function GetDNByID(ID)
   Dim rs
   Set rs = QueryLDAP(GetRootDN, "(sAMAccountName=" & isValidString(ID) & ")", "distinguishedName", "subtree")
   If Not rs.EOF Then GetDNByID = stripHTML(rs("distinguishedName"))
   rs.Close
   Set rs = Nothing

End Function

Function GetVADNByID(ID)
strDomain = "DC=va,DC=gov"	
Set objCommand = CreateObject("ADODB.Command") 	

objCommand.ActiveConnection = LDAPConnection
strQuery ="select sAMAccountName, userAccountControl,cn, distinguishedName from 'GC://"+strDomain+"' "
strQuery = strQuery & " WHERE objectClass='person' "
strQuery = strQuery & "  and ( (sAMAccountName='" & isValidString(ID) & "*') or (cn='" & isValidString(ID) & "*') ) "
strQuery = strQuery & " order by sAMAccountName "

objCommand.CommandText = strQuery 
objCommand.Properties("Page Size") = 1000 	
objCommand.Properties("Timeout") = 30 	
objCommand.Properties("Cache Results") = true
Set objRecordSet = objCommand.Execute 	
if not objRecordSet.EOF then GetVADNByID = objRecordSet.Fields("distinguishedName").value 
 objRecordSet.close

End Function
  
' Get sAMAccountName by object's SID
' Usage: <sAMAccountName> = GetIDBySid(<SID Byte()>)
'Function GetIDBySid(objectSid)
'   If TypeName(objectSid) = "Byte()" Then
'      GetIDBySid = GetObject("LDAP://<SID=" & ByteArrToHexString(objectSid) & ">").Get("sAMAccountName")
'   End If
'End Function
 
 
' =====================================
' LDAP routines
' =====================================
 
' Get Root DN of logged in domain (e.g. DC=yourdomain,DC=com)
' Usage: <DN> = GetRootDN
Function GetRootDN
   GetRootDN = GetObject("LDAP://RootDSE").Get("defaultNamingContext")  
End Function
 
' Get/create singleton LDAP ADODB connection object
' Usage: <Connection object ref> = LDAPConnection
'    or: LDAPConnection.<property or method>
Dim l_LDAPConnection
Function LDAPConnection
   If IsEmpty(l_LDAPConnection) Then
      Set l_LDAPConnection = CreateObject("ADODB.Connection")
      l_LDAPConnection.Provider = "ADSDSOObject"
      l_LDAPConnection.Open "ADs Provider"
   End If
   Set LDAPConnection = l_LDAPConnection
End Function
 
 

' Get/create singleton LDAP ADODB connection object
' Usage: <Connection object ref> = LDAPConnection
'    or: LDAPConnection.<property or method>

Function LDAPConnection2

      Set l_LDAPConnection2 = CreateObject("ADODB.Connection")
	  ' Use ADO to search Active Directory.
	 l_LDAPConnection2.Provider = "ADsDSOObject"
	 l_LDAPConnection2.Properties("User ID") = "DNS      \DNS   CATSvcACCT"
	 l_LDAPConnection2.Properties("Password") = "(SA)@rm3110"
	 l_LDAPConnection2.Properties("Encrypt Password") = TRUE
	 l_LDAPConnection2.Properties("ADSI Flag") = 1
	 l_LDAPConnection2.Provider = "ADSDSOObject"
	 l_LDAPConnection2.Open "Active Directory Provider"
   Set LDAPConnection2 = l_LDAPConnection2
End Function
 
' Close the LDAPConnection singleton object
' Usage: CloseLDAPConnection
Sub CloseLDAPConnection
   If IsObject(l_LDAPConnection) Then
      If l_LDAPConnection.State = 1 Then l_LDAPConnection.Close
   End If
   If IsObject(l_LDAPConnection2) Then
      If l_LDAPConnection2.State = 1 Then l_LDAPConnection2.Close
   End If
   l_LDAPConnection = Empty
   l_LDAPConnection2 = Empty
End Sub
 
' Query LDAP helper, return RecordSet
' Usage: <RecordSet object ref> = QueryLDAP(<DN>, <LDAP Filter>, <Attributes CSV>, <Scope>
' Scope can be: "subtree", "onelevel", or "base"
' Be sure to close the RecordSet object when done with it
Function QueryLDAP(DN, Filter, AttributeList, Scope)
   Set QueryLDAP = LDAPConnection.Execute("<" & LdapUri(DN) & ">;" & Filter & ";" & AttributeList & ";" & Scope)
   
End Function

'' Function delete a member of a group
' Usage: group name, samaccount
Function RemoveMemberFromGroup(GroupID, MemberID, event_actor)
  on error resume next
  Const ADS_PROPERTY_DELETE = 4
  GroupDN = GetDNByID(GroupID)
  MemberDN = GetVADNByID(MemberID)
  Set objGroup = GetObject(LdapURI(GroupDN))
  objGroup.PutEx ADS_PROPERTY_DELETE, "member", Array(MemberDN)
  objGroup.SetInfo
  If Err.Number <> 0 Then
      Err.clear
      On Error Goto 0
      line = "    Failed to delete " & MemberID & " from " & groupID & "  <<<<<<<"
    Else
      line = "  Deleted " & MemberID & " from " & groupID
      addCount = addCount + 1
    End If
   Set ObjGroup = nothing
   qString = "INSERT INTO tblActivityLog (LogType,logUsername, logMessage, DateInserted) VALUES ('ACTIVITY','" & isValidString(event_actor) & "','REMOVE USER: " & isValidString(MemberID) & " was removed from group: " & isValidString(GroupID) & "',GetDate())"
   conn.execute(qString)
   
   RemoveMemberFromGroup = line
End Function

'' Function delete a member of a group
' Usage: group name, samaccount
Function AddMemberToGroup(GroupID, MemberID, event_actor)
 on error resume next
  GroupDN = GetDNByID(GroupID)
  MemberDN = GetVADNByID(MemberID)

 'Response.write "MemberDN=" & MemberDN & "<p>GroupDN=" & GroupDN
 Const ADS_PROPERTY_APPEND = 3 
  Set objGroup = GetObject(LdapURI(GroupDN))
  objGroup.PutEx ADS_PROPERTY_APPEND, "member", Array(MemberDN)
  objGroup.SetInfo
    If Err.Number <> 0 Then

    '  On Error Goto 0
      line = "    Failed to add " & MemberID & " to " & groupID & "  <<<<<<< Error Number: " & Err.Number & " - " & Err.Description
	        Err.clear
			
	  qString = "INSERT INTO tblActivityLog (LogType,logUsername, logMessage, DateInserted) VALUES ('ERROR','" & isValidString(event_actor) & "','FAILED TO ADD USER: " & isValidString(MemberID) & " to group: " & isValidString(GroupID) & "',GetDate())"
	  conn.execute(qString)
			
    Else
      line = "  Adding " & MemberID & " to " & groupID
      addCount = addCount + 1
	  
	  qString = "INSERT INTO tblActivityLog (LogType,logUsername, logMessage, DateInserted) VALUES ('ACTIVITY','" & isValidString(event_actor) & "','ADDED USER: " & isValidString(MemberID) & " was added to group: " & isValidString(GroupID) & "',GetDate())"
	  conn.execute(qString)
	  
    End If
   Set ObjGroup = nothing
	AddMemberToGroup = line
End Function

'''' HEC FUNCTIONS
Function getMembersOfGroup(ID, site_number)
   Dim members
   Dim arrUsers(1000,11)
Dim arrCount, authenticatedUser
arrCount = 0
sql = "select max(last_updated_date) as maxDate from tbl_users where site_number=" & CheckString(site_number, "")

set rst = conn.execute(sql)
if not rst.EOF and isDate(rst("maxDate")) then 
	last_updated_date = rst("maxDate")
else
    last_updated_Date = dateadd("h",-9,now())
End if
rst.Close()

if datediff("h",last_updated_date,now()) <= 8 then
' Pull from the database
  sql = " select * from tbl_users where site_number=" & CheckString(site_number, "")
  set rst = conn.execute(sql)
  while not rst.EOF
    
	mail = rst("user_email")
	lastname = rst("user_last_name")
	firstname = rst("user_first_name")
	middlename= rst("user_middle_name")
	phone = rst("user_phone")
	user_id = rst("user_id")
	site_number = rst("site_number")
	
	members = members & "<li><a href='mailto:" & mail & "'>" & lastname &", " & firstname & " " & middlename & "</a> - " &phone 
	if Session("USER_ADMIN") = "YES" or Session("VAMC_Site") = "'" & site_number & "'" then members = members & " <a href='#' onClick=""return removeUser('" & site_number & "','" & user_id & "')""><img src='images/close.gif' alt='Delete this user?'></a></li>" & vbCrLf 
	members = members  & vbCrLf
	rst.MoveNext()
  Wend
  rst.Close()
Else
 ' PULL FROM AD
on error resume next
    objectDN = GetDNByID(ID)
   Set objGroup = GetObject(LdapURI(objectDN))
   objGroup.GetInfo
   arrMemberOf = objGroup.GetEx("member")
   For Each strMember in arrMemberOf
   	Set objUser = GetObject(LdapURI(strMember))
 	Select Case objUser.class
   		Case "user"
  			members = members & UserInfo(objUser, site_number)
   		Case "group"
      	enumGroupMembers objUser.distinguishedName, site_number
	 End Select
     
   Next
  
 End If ' End of pulling from AD
 
   getMembersOfGroup = members
 End Function

 Function getADMembersOfGroup(ID, site_number)
  'on error resume next
    objectDN = GetDNByID(ID)
	Set objGroup = GetObject(LdapURI(objectDN))
   objGroup.GetInfo
   arrMemberOf = objGroup.GetEx("member")
   Response.write  "<table border=0 cellpadding=0 cellspacing=0 class='sortable-onload-0' ID='ADMembersList'><thead><tr><th class='sortable'>User Name</th><th class='sortable'>Phone</TH><th>&nbsp;</th></tr></thead>"
   numrows = 1
   For Each strMember in arrMemberOf
   	Set objUser = GetObject(LdapURI(strMember))
 	Select Case objUser.class
   		Case "user"
  			Response.write stripHTML(UserInfo(objUser, site_number))
			numrows = numrows + 1
			'if numrows mod 100 = 0 then
			'Response.write "</table>" & vbCrLf & "<table border=0 cellpadding=0 cellspacing=0 class='sortable'><thead><tr><th class='sortable'>User Name</th><th class='sortable'>Phone</TH><th>&nbsp;</th></tr></thead>"
			'Response.flush()
			'End if
			Response.flush()
   		Case "group"
      	'enumGroupMembers objUser.distinguishedName, site_number
	 End Select
     
   Next
   Response.write "</table>" &vbCrLf
   Response.write "<script>if (fdTableSort) fdTableSort.init('ADMembersList',0)</script>"
   getADMembersOfGroup = ""
 End Function
 
 Sub enumGroupMembers(ByVal sObjDN, site_number)
 Dim oContainer, obj, sDN
   Set oContainer=GetObject (LdapURI(sObjDN))

 For each obj in oContainer.members
   Select Case LCase(obj.Class)
  Case "user" , "contact"
   UserInfo obj, site_number
   UserCount = UserCount + 1
  Case "group"
   EnumGroupMembers obj.distinguishedName, site_number
 End Select
 Next
End Sub
'------------------------------------------------------------------------------
' Store user's information into an array
'------------------------------------------------------------------------------
Function UserInfo(ByVal objUser, site_number)
found = false

	phone = objUser.telephoneNumber
	fax = objUser.facsimileTelephoneNumber
	zipcode = objUser.postalCode
    mail = objUser.mail
	title = objUser.title
	office = objUser.physicalDeliveryOfficeName
	lastname = objUser.sn
	firstname = objUser.givenName
	middlename = objUser.initials
	department = objUser.department
	user_id = objUser.sAMAccountName
	if instr(lastname,"Group Review") = 0 then
	
	sql = "select * from tbl_users where user_id=" & CheckString(User_ID, "")
	set rst = conn.execute(sql)
	if not rst.EOF  then
		if  site_Number <> "EDITORS" and  site_Number <> "VISN" and  site_Number <> "TECH" and  site_Number <> "ADMIN" then
		sql = "update tbl_users set "
		if firstname <> "" then sql = sql & "user_first_name=" & CheckString(firstname, ", ")
		if lastname <> "" then sql = sql & "user_last_name=" & CheckString(lastname, ", ")
		if middlename <> "" then sql = sql & "user_middle_name=" & CheckString(middlename, ", ")
		if mail <> "" then sql = sql & "user_email=" & CheckString(mail, ", ")
		if phone <> "" then sql = sql & "user_phone=" & CheckString(phone, ", ")
		sql = sql & " site_number='" & isValidString(site_number) & "', last_updated_date=getdate() where user_id=" & CheckString(User_ID, "")
	conn.execute(sql)
	   End If
	elseif user_id <> "" and len(user_id) <= 15 and firstname <> "" and lastname <> "" then
	sql = "insert into tbl_users (User_id, user_first_name, user_middle_name, user_last_name, user_email, user_phone, site_number) values ("
	sql = sql & CheckString(user_Id, ", ")
	sql = sql & CheckString(firstname, ", ")
	sql = sql & CheckString(middlename, ", ")
	sql = sql & CheckString(lastname, ", ")
	sql = sql & CheckString(mail, ", ")
	sql = sql & CheckString(phone, ", ")
	sql = sql & CheckString(site_number, ") ")
	'Response.write "<p>" & sql
	conn.execute(sql)
	End If
	rst.close()
	 members = "<tr><td class='td_report'><a href='userprofile.asp?user_id=" & user_id & "'>" & lastname &", " & firstname & " " & middlename & "</a> </td><td class='td_report'> " &phone & "</td>"
	 if Session("USER_ADMIN") = "YES" or instr(Session("VAMC_Site"),site_number) > 0 then 
	 	members = members & "<td class='td_report'><a href='#' onClick=""return removeUser('" & site_number & "','" & user_id & "')""><img src='images/close.gif' alt='Delete this user?'></a></td>" & vbCrLf 
	 else
	    members = members & "<td class='td_report'>&nbsp;</td>"
	 End If
		members = members & "</tr>"
	members = members &  vbCrLf
	UserInfo = members
	End if


End Function



%>